%define pypi_name dateparser

# dl.fbaipublicfiles.com
%def_disable check

Name: python3-module-%pypi_name
Version: 1.2.1
Release: alt1

Summary: Python parser for human readable dates 
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/dateparser

Vcs: https://github.com/scrapinghub/dateparser.git

Source: https://github.com/scrapinghub/dateparser/archive/v%version/%pypi_name-%version.tar.gz
BuildArch: noarch

#grep calendars setup.py 
#'calendars': ['convertdate', hijridate'],

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3(wheel) python3(setuptools)
BuildRequires: python3-module-mock
BuildRequires: python3-module-parameterized
BuildRequires: python3-module-dateutil python3-module-tzlocal
BuildRequires: python3-module-pytz python3-module-regex
BuildRequires: python3-module-sphinx-devel python3-module-sphinx_rtd_theme
%{?_enable_check:BuildRequires: python3-module-tox
BuildRequires: python3-module-flake8 python3-module-pytest
BuildRequires: python3-module-pytest-cov python3-module-parameterized
BuildRequires: python3-module-convertdate
BuildRequires: python3-module-ruamel-yaml python3-module-umalqurra
BuildRequires: python3-module-hijridate python3-module-langdetect
BuildRequires: python3(fasttext) python3(parsel) python3(git)}

%description
Date parsing library designed to parse dates from HTML pages.

%package pickles
Summary: Pickles for %pypi_name
Group: Development/Python3

%description pickles
Date parsing library designed to parse dates from HTML pages.

This package contains pickles for %pypi_name.

%package docs
Summary: Documentation for %pypi_name
Group: Development/Documentation
BuildArch: noarch

%description docs
Date parsing library designed to parse dates from HTML pages.

This package contains documentation for %pypi_name.

%prep
%setup -n %pypi_name-%version

%prepare_sphinx3 .
ln -s ../objects.inv docs/

%build
%pyproject_build

%install
%pyproject_install
export PYTHONPATH=$PWD
%make -C docs pickle html SPHINXBUILD=sphinx-build-3

cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%pypi_name/

%check
%tox_check

%files
%_bindir/%pypi_name-download
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle
%doc *.rst

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*


%changelog
