%define _unpackaged_files_terminate_build 1
%define oname django-model-utils

Name: python3-module-%oname
Version: 5.0.0
Release: alt1

Summary: Django model mixins and utilities
License: BSD
Group: Development/Python3
Url: https://pypi.python.org/pypi/django-model-utils/
BuildArch: noarch

# https://github.com/carljm/django-model-utils.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-setuptools

%description
Django model mixins and utilities.

django-model-utils supports Django 1.4.10 and later on Python 2.6, 2.7,
3.2, 3.3 and 3.4.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
Django model mixins and utilities.

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
Django model mixins and utilities.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
Django model mixins and utilities.

This package contains documentation for %oname.

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%pyproject_build

%install
%pyproject_install

export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C docs pickle
%make -C docs html

install -d %buildroot%python3_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/

mv tests/ %buildroot%python3_sitelibdir/%oname/

%files
%doc *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*

%files tests
%python3_sitelibdir/*/tests

%changelog
