%define oname geventhttpclient

%def_without check

Name: python3-module-%oname
Version: 2.3.1
Release: alt1

Summary: http client library for gevent
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/geventhttpclient/

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-gevent
BuildRequires: python3-module-six
BuildRequires: python3-module-brotlipy
BuildRequires: python3-module-dpkt
BuildRequires: python3-module-urllib3
BuildRequires: python3-module-certifi
%endif

%description
A high performance, concurrent HTTP client library for python using
gevent.

geventhttpclient use a fast http parser, written in C, originating from
nginx, extracted and modified by Joyent.

geventhttpclient has been specifically designed for high concurrency,
streaming and support HTTP 1.1 persistent connections. More generally it
is designed for efficiently pulling from REST APIs and streaming API's
like Twitter's.

Safe SSL support is provided by default.

%prep
%setup

%build
%python3_build_debug

%install
%python3_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-3 -m 'not online' -k 'not test_brotli_response'

%files
%doc PKG-INFO
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-*.egg-info

%changelog
