%define _unpackaged_files_terminate_build 1
%define pypi_name graphviz
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 0.20.3
Release: alt2
Summary: Simple Python interface for Graphviz
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/graphviz/
VCS: https://github.com/xflr6/graphviz
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-%release.patch
Requires: graphviz
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: graphviz
# dot's output is polluted with
# Fontconfig error: Cannot load default config file: No such file: (null)
# if /etc/fonts/fonts.conf is missing
BuildRequires: fontconfig
%pyproject_builddeps_metadata_extra test
%endif

%description
%summary

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
# pytest 8.1.1:
# - https://github.com/xflr6/graphviz/issues/219
# - https://github.com/pytest-dev/pytest/issues/12123
%pyproject_run -- python3 run-tests.py \
    --ignore ./tests/conftest.py \
    --ignore ./tests/backend/conftest.py

%files
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
