%define oname h2

Name: python3-module-h2
Version: 4.1.0
Release: alt1

Summary: HTTP/2 State-Machine based protocol implementation

Group: Development/Python3
License: MIT
Url: https://github.com/python-hyper/hyper-h2

# Source-url: https://github.com/python-hyper/hyper-h2/archive/v%version.tar.gz
Source: %name-%version.tar

# https://github.com/python-hyper/h2/issues/1268
Patch1: eabe727282e7a7aa3254773292f86cf341bdc597.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3
BuildRequires: python3 >= 3.6.1
BuildRequires: python3-module-setuptools

# generated by 'epm restore --dry-run' from h2/setup.py install_requires
%py3_use hyperframe < 7
%py3_use hyperframe >= 6.0
%py3_use hpack < 5
%py3_use hpack >= 4.0


# for test
BuildRequires: python3-module-hypothesis

%description
This repository contains a pure-Python implementation of a HTTP/2 protocol
stack. It's written from the ground up to be embeddable in whatever program you
choose to use, ensuring that you can speak HTTP/2 regardless of your
programming paradigm.

%prep
%setup
%patch1 -p1

%build
%python3_build_debug

%install
%python3_install
%python3_prune

%check
PYTHONPATH=$(pwd)/build/lib py.test3

%files
%python3_sitelibdir/h2/
%python3_sitelibdir/h2*.egg-info/

%changelog
