%define _unpackaged_files_terminate_build 1
%define oname h5netcdf

%def_with check

Name: python3-module-%oname
Version: 1.3.0
Release: alt1

Summary: Pythonic interface to netCDF4 via h5py

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/h5netcdf
VCS: https://github.com/shoyer/h5netcdf

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-h5py
BuildRequires: python3-module-netCDF4
BuildRequires: python3-module-Cython
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-cftime
%endif

%py3_provides %oname
%py3_requires h5py


%description
A Python interface for the netCDF4 file-format that reads and writes
HDF5 files API directly via h5py, without relying on the Unidata netCDF
library.

This is an experimental project. It currently passes basic tests for
reading and writing netCDF4 files with Python, but it has not been
tested for compatibility with other netCDF4 interfaces.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_create_default_config
%tox_check_pyproject

%files
%doc LICENSE *.rst
%python3_sitelibdir/*

%changelog
