%define _unpackaged_files_terminate_build 1
%define oname http-parser

%def_with check

Name: python3-module-%oname
Version: 0.9.0
Release: alt3
Summary: http request/response parser
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/http-parser/

# https://github.com/benoitc/http-parser.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(Cython)
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(tox)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3(tox_console_scripts)
%endif

%py3_provides %oname

%description
HTTP request/response parser for Python compatible with Python 2.x
(>=2.6), Python 3 and Pypy. If possible a C parser based on http-parser
from Ryan Dahl will be used.

%prep
%setup

# regenerate with cython later
rm -f http_parser/parser.c

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc NOTICE *.rst *.md THANKS examples
%python3_sitelibdir/*

%changelog
