%define _unpackaged_files_terminate_build 1
%define pypi_name python-ldap
%define mname ldap

%def_with check

Name: python3-module-%mname
Version: 3.4.4
Release: alt1
Summary: Python modules for implementing LDAP clients
License: Python-style or MIT
Group: Development/Python3
Url: https://www.python-ldap.org
Vcs: https://github.com/python-ldap/python-ldap
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
%pyproject_runtimedeps_metadata
# mapping from PyPI name
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
Provides: python3-module-pyldap = %EVR
Obsoletes: python3-module-pyldap < %EVR
BuildRequires(pre): rpm-build-pyproject
BuildRequires: libldap-devel
BuildRequires: libsasl2-devel
BuildRequires: libssl-devel
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
BuildRequires: openldap-servers
BuildRequires: openldap-clients
%endif

%description
python-ldap provides an object-oriented API to access LDAP
directory servers from Python programs. Mainly it wraps the
OpenLDAP client libs for that purpose.

Additionally the package contains modules for other LDAP-related
stuff (e.g. processing LDIF, LDAPURLs, LDAPv3 sub-schema, etc.).

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

# Fix python interpreter path in Demo directory
grep -rl '^#!/usr/bin/env python' | \
	xargs sed -i '1s|^#!/usr/bin/env python|#!/usr/bin/python3|'

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
export BIN="$PATH:%_sbindir"
%pyproject_run_unittest discover -v -s Tests -p 't_*'

%files
%doc LICENCE CHANGES README TODO Demo
%python3_sitelibdir/slapdtest/
%python3_sitelibdir/_ldap.cpython-*.so
%python3_sitelibdir/ldap
%python3_sitelibdir/ldapurl.py*
%python3_sitelibdir/ldif.py*
%python3_sitelibdir/__pycache__/*
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
