%define  oname llvmlite
%define  llvm_version 14.0
%define  optflags_lto -flto=thin

#[armh] LLVM ERROR: Symbol not found: __aeabi_unwind_cpp_pr0
%ifnarch armh
%def_with check
%else
%def_without check
%endif

Name:    python3-module-%oname
Version: 0.42.0
Release: alt1

Summary: A lightweight LLVM python binding for writing JIT compilers

License: BSD-2-Clause
Group:   Development/Python3
URL:     https://pypi.org/project/llvmlite
VCS:     https://github.com/numba/llvmlite

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3 python3-module-setuptools python3-module-wheel
BuildRequires: clang%{llvm_version} llvm%{llvm_version}-devel libstdc++-devel lld%{llvm_version}

Source:  %name-%version.tar

%description
A lightweight LLVM python binding for writing JIT compilers

The old llvmpy  binding exposes a lot of LLVM APIs but the mapping of
C++-style memory management to Python is error prone. Numba_ and many JIT
compilers do not need a full LLVM API.  Only the IR builder, optimizer,
and JIT compiler APIs are necessary.

llvmlite is a project originally tailored for Numba's needs, using the
following approach:

* A small C wrapper around the parts of the LLVM C++ API we need that are
  not already exposed by the LLVM C API.
* A ctypes Python wrapper around the C API.
* A pure Python implementation of the subset of the LLVM IR builder that we
  need for Numba.

%prep
%setup
sed -i 's|"version": "0+unknown"|"version": "%version"|' versioneer.py

%build
%remove_optflags -frecord-gcc-switches
%add_optflags -grecord-gcc-switches -fPIC -DNDEBUG
export ALTWRAP_LLVM_VERSION=%{llvm_version}
export CXX=clang
export LDFLAGS='-fuse-ld=lld'
%pyproject_build

%install
%pyproject_install

%check
%__python3 ./runtests.py

%files
%doc LICENSE CHANGE_LOG *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}

%changelog
