%def_disable snapshot
%define _unpackaged_files_terminate_build 1
%define pypi_name markdown
%define modname Markdown
%define ver_major 3.8

%def_enable check

Name: python3-module-%pypi_name
Version: %ver_major
Release: alt1

Summary: Python implementation of Markdown text-to-HTML convertor.
Group: Development/Python3
License: BSD-3-Clause
Url: https://pypi.python.org/pypi/Markdown/

Vcs: https://github.com/waylan/Python-Markdown.git

%if_disabled snapshot
Source: https://pypi.io/packages/source/m/%pypi_name/%pypi_name-%version.tar.gz
%else
Source: Markdown-%version.tar
%endif
# revert this until setuptools_ver 77.0
Patch10: markdown-3.8-up-PEP639.diff

BuildArch: noarch

%define metadata_ver 4.4
%define setuptools_ver 77.0

Requires: python3-module-Pygments
#markdown/util.py:    import importlib_metadata as metadata
Requires: python3-module-importlib-metadata >= %metadata_ver

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3(wheel) python3-module-setuptools
# >= %setuptools_ver
BuildRequires: python3-module-yaml
BuildRequires: python3-module-coverage
BuildRequires: python3-module-Pygments
BuildRequires: python3-module-importlib-metadata >= %metadata_ver
%{?_enable_check:BuildRequires: python3(tox)}

%description
Markdown is a plain text formatting syntax designed to be as readable as
possible while being structured enough to allow conversion to other formats.

This package contains Python implementation of markdown-to-HTML convertor.

%package docs
Summary: Documentation for Markdown
Group: Development/Documentation
BuildArch: noarch

%description docs
Markdown is a plain text formatting syntax designed to be as readable as
possible while being structured enough to allow conversion to other formats.

This package contains documentation for Markdown.

%prep
%setup -n %pypi_name-%version
%patch10 -p1 -R

%build
%pyproject_build

%install
%pyproject_install
mv %buildroot%_bindir/%{pypi_name}_py \
    %buildroot%_bindir/%{pypi_name}_py3

%check
%tox_check
export PYTHONPATH=%buildroot%python3_sitelibdir
%buildroot%_bindir/%{pypi_name}_py3 README.md >README.html

%files
%_bindir/%{pypi_name}_py3
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%doc README* docs/changelog.md

%changelog
