%define oname mdp

# 16 tests (test_dtype_consistency) fail on armh
%ifnarch armh aarch64
%def_with check
%else
%def_without check
%endif

%define release_tag 3.6
%define commit_num .15
%define commit_id .g64f14eee

Name: python3-module-%oname
Version: %release_tag.0%commit_num%commit_id
Release: alt4.1

Summary: Modular toolkit for Data Processing

Group: Development/Python3
License: BSD-3-Clause
URL: https://pypi.org/project/MDP/
VCS: https://github.com/mdp-toolkit/mdp-toolkit

Source: %name-%version.tar
Source1: MDP-tutorial.pdf

Patch: no_future.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-zombie-imp
%endif

%add_python3_req_skip shogun UserDict pp libsvm.svmutil __future__

%description
Modular toolkit for Data Processing (MDP) is a Python data processing
framework.

From the user's perspective, MDP is a collection of supervised and
unsupervised learning algorithms and other data processing units that
can be combined into data processing sequences and more complex
feed-forward network architectures.

From the scientific developer's perspective, MDP is a modular framework,
which can easily be expanded. The implementation of new algorithms is
easy and intuitive. The new implemented units are then automatically
integrated with the rest of the library.

The base of available algorithms is steadily increasing and includes, to
name but the most common, Principal Component Analysis (PCA and NIPALS),
several Independent Component Analysis algorithms (CuBICA, FastICA,
TDSEP, JADE, and XSFA), Slow Feature Analysis, Gaussian Classifiers,
Restricted Boltzmann Machine, and Locally Linear Embedding.

%package tests
Summary: Tests for Modular toolkit for Data Processing
Group: Development/Python3
Requires: %name = %EVR

%description tests
Modular toolkit for Data Processing (MDP) is a Python data processing
framework.

This package contains tests for MDP.

%package doc
Summary: Documentation for Modular toolkit for Data Processing
Group: Development/Documentation
BuildArch: noarch

%description doc
Modular toolkit for Data Processing (MDP) is a Python data processing
framework.

This package contains documentation for MDP.

%prep
%setup

%patch -p1

install -p -m644 %SOURCE1 .

sed -i 's|#! /usr/bin/env python|#! /usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_create_default_config
%tox_check_pyproject -- mdp
%tox_check_pyproject -- bimdp

%files
%python3_sitelibdir/bimdp
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pep427_name %oname}-%release_tag.dist-info/
%exclude %python3_sitelibdir/%oname/test
%exclude %python3_sitelibdir/bimdp/test

%files tests
%python3_sitelibdir/%oname/test
%python3_sitelibdir/bimdp/test

%files doc
%doc *.pdf CHANGES CHECKLIST COPYRIGHT
%doc README.md TODO


%changelog
