%define oname mpmath

Name: python3-module-%oname
Version: 1.2.1
Release: alt1

Summary: Python library for arbitrary-precision floating-point arithmetic

License: New BSD License
Group: Development/Python3
Url: http://mpmath.org/

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-setuptools_scm

%{?!_disable_check:BuildRequires: xvfb-run}
BuildRequires: pytest3


%description
Mpmath is a pure-Python library for multiprecision floating-point
arithmetic. It provides an extensive set of transcendental functions,
unlimited exponent sizes, complex numbers, interval arithmetic,
numerical integration and differentiation, root-finding, linear algebra,
and much more. Almost any calculation can be performed just as well at
10-digit or 1000-digit precision, and in many cases mpmath implements
asymptotically fast algorithms that scale well for extremely high
precision work. Mpmath internally uses Python's builtin long integers by
default, but automatically switches to GMP/MPIR for much faster
high-precision arithmetic if gmpy is installed.

If matplotlib is available, mpmath also provides a convenient plotting
interface.

%prep
%setup

%build
%python3_build

%install
%python3_install
%python3_prune

%check
xvfb-run pytest3

%files
%doc README.rst
%python3_sitelibdir/*

%changelog
