%define oname mysqlclient

%def_with docs
# check needs running mysql server
%def_without check

Name: python3-module-%oname
Version: 2.2.4
Release: alt1

Summary: Python interface to MySQL
Group: Development/Python3

License: GPL-2.0
Url: https://pypi.python.org/pypi/mysqlclient/
# https://github.com/PyMySQL/mysqlclient-python.git
Source: %name-%version.tar

Conflicts: python3-module-MySQLdb
Conflicts: python3-module-MySQLdb2
Provides: python3-module-MySQLdb
%py3_provides MySQLdb

BuildRequires(pre): rpm-build-python3
Buildrequires: libmysqlclient21-devel

%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx_rtd_theme
%endif

%description
mysqlclient is a fork of MySQL-python. It adds Python 3.3 support and
merges some pull requests.

%if_with docs
%package docs
Summary: Documentation for %oname
Group: Development/Documentation

BuildArch: noarch

%description docs
This package contains documentation for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
This package contains pickles for %oname.
%endif

%prep
%setup
%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv doc/
%endif

%build
%python3_build
%if_with docs
export PYTHONPATH=%buildroot%python3_sitelibdir
%make SPHINXBUILD="sphinx-build-3" -C doc html
%make SPHINXBUILD="sphinx-build-3" -C doc pickle
%make SPHINXBUILD="sphinx-build-3" -C doc man
%endif

%install
%python3_install
%if_with docs
install -d %buildroot%python3_sitelibdir/%oname
cp -fR doc/_build/pickle %buildroot%python3_sitelibdir/%oname/
mkdir -p %buildroot%_man1dir/
install -m0644 doc/_build/man/mysqldb.1 %buildroot%_man1dir/
%endif

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-3

%files
%doc HISTORY* *.md
%python3_sitelibdir/%oname
%python3_sitelibdir/MySQLdb
%python3_sitelibdir/%oname-%version-py%_python3_version.egg-info
%if_with docs
%_man1dir/*
%exclude %python3_sitelibdir/%oname/pickle

%files pickles
%python3_sitelibdir/%oname/pickle

%files docs
%doc doc/_build/html/*
%endif

%changelog
