%global modname nbxmpp
Name: python3-module-%modname
Version: 4.5.3
Release: alt1
Summary: Python library for non-blocking use of Jabber/XMPP
License: GPLv3+
Url: https://python-nbxmpp.gajim.org/
Group: Development/Python3

Packager: Ilya Mashkin <oddity@altlinux.ru>

Source0: https://dev.gajim.org/gajim/python-nbxmpp/-/archive/nbxmpp-%version/python-nbxmpp-%version.tar.bz2
BuildArch: noarch
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel pyproject-build rpm-macros-python3 python3-module-build
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)


# python-nbxmpp 4.0.0 has been ported to libsoup3
Requires: libsoup3.0-gir

# does not work with gajim < 1.8
Conflicts: gajim < 1.8
Obsoletes: python3-nbxmpp-doc

%description
python-nbxmpp is a Python library that provides a way for Python applications
to use Jabber/XMPP networks in a non-blocking way.

Features:
- Asynchronous
- ANONYMOUS, EXTERNAL, GSSAPI, SCRAM-SHA-1, DIGEST-MD5, PLAIN, and
    X-MESSENGER-OAUTH2 authentication mechanisms.
- Connection via proxies
- TLS
- BOSH (XEP-0124)
- Stream Management (XEP-0198)


%prep
%setup -n python-%modname-%version

%build
%pyproject_build

%install
%pyproject_install

%files
%doc README.md ChangeLog
%python3_sitelibdir/%modname
%python3_sitelibdir/%modname-%version.dist-info

%changelog
