%define _unpackaged_files_terminate_build 1
%def_with check
%define pypi_name networkx

Name:           python3-module-%pypi_name
Epoch:          2
Version:        3.3
Release:        alt3
Summary:        Creates and Manipulates Graphs and Networks
Group:          Development/Python3
License:        BSD-3-Clause
URL:            http://networkx.github.io

BuildArch:      noarch

# https://github.com/networkx/networkx.git
Source:         %name-%version.tar
Source1: %pyproject_deps_config_name
%pyproject_runtimedeps_metadata
BuildRequires: python3-devel 
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: python3-module-pytest python3-module-pytest-cov
BuildRequires: python3-module-numpy python3-module-numpy-testing
BuildRequires: python3-module-lxml python3-module-pandas-tests
BuildRequires: python3-module-matplotlib python3-module-fonttools
%endif

Requires: %name-drawing = %EVR

%description
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

%package core
Summary: Creates and Manipulates Graphs and Networks (Python 3)
Group: Development/Python3
Requires: python3-module-decorator
Requires: python3-module-yaml
%add_python3_req_skip tests
%add_python3_req_skip networkx.tests.test

%description core
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

%package drawing
Summary: Creates and Manipulates Graphs and Networks (Python 3)
Group: Development/Python3
Requires: %name-core = %EVR
Requires: python3-module-pygraphviz >= 1.5
Requires: python3-module-pygraphviz < 2.0
Requires: python3-module-pydot >= 1.4.1
Requires: python3-module-matplotlib >= 3.2

%description drawing
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package provides support for graph visualizations.

%package tests
Summary: Tests for NetworkX (Python 3)
Group: Development/Python3
Requires: %name = %EVR

%description tests
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package contains tests for NetworkX.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files

%files core
%doc LICENSE.txt
%doc README.rst CODE_OF_CONDUCT.rst CONTRIBUTING.rst
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%pypi_name-%version.dist-info
%exclude %python3_sitelibdir/%pypi_name/drawing
%exclude %python3_sitelibdir/%pypi_name/tests
%exclude %python3_sitelibdir/%pypi_name/conftest.py
%exclude %python3_sitelibdir/%pypi_name/__pycache__/conftest.*
%exclude %python3_sitelibdir/%pypi_name/*/tests
%exclude %python3_sitelibdir/%pypi_name/*/*/tests

%files drawing
%python3_sitelibdir/%pypi_name/drawing
%exclude %python3_sitelibdir/%pypi_name/drawing/tests

%files tests
%python3_sitelibdir/%pypi_name/conftest.py
%python3_sitelibdir/%pypi_name/__pycache__/conftest.*
%python3_sitelibdir/%pypi_name/tests
%python3_sitelibdir/%pypi_name/*/tests
%python3_sitelibdir/%pypi_name/*/*/tests

%changelog
