%define pypi_name pyopenssl
%define oname pyOpenSSL

%define typing_extensions %(%__python3 -c 'import sys;print(int(sys.version_info < (3, 13)))')

%def_without doc_package

Name: python3-module-openssl
Version: 25.1.0
Release: alt1.1

Summary: Python wrapper module around the OpenSSL library
Summary(ru_RU.UTF-8): Модуль-обвязка библиотеки OpenSSL для python

License: Apache-2.0
Group: Development/Python3
Url: https://github.com/pyca/pyopenssl

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

# mapping from PyPI name
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
Provides: python3-module-OpenSSL = %EVR
Obsoletes: python3-module-OpenSSL

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools

# generated by 'epm restore --dry-run' from pyOpenSSL/setup.py install_requires
%py3_use cryptography < 46
%py3_use cryptography >= 41.0.5
%if %typing_extensions
%py3_use typing-extensions >= 4.9
%endif

%description
High-level wrapper around a subset of the OpenSSL library, includes
	* SSL.Connection objects, wrapping the methods of Python's
	  portable sockets
	* Callbacks written in Python
	* Extensive error-handling mechanism, mirroring OpenSSL's
	  error codes
	...  and much more ;)

%description -l ru_RU.UTF-8
Высокоуровневая обвязка для подмножества библиотеки OpenSSL.
Включает в себя:
	* Объекты SSL.Connection для работы с переносимыми сокетами
          python
	* Коллбэки, написанные на python
	* Широкие возможности по обработке ошибок, отражающие коды
	  ошибок OpenSSL
	... И это еще не все ;)


%if_with doc_package
%package doc
Summary: %oname documentation and example programs
Summary(ru_RU.UTF-8): Документация по API и примеры программ для %oname
Group: Development/Python
BuildArch: noarch

%description doc
%modulename is a high-level wrapper around a subset of the OpenSSL
library. Install python-pyOpenSSL-doc if you need the API
documentation and example programs for %oname.

%description doc -l ru_RU.UTF-8
%oname - Высокоуровневая обвязка для подмножества библиотеки
OpenSSL. Установите python-%oname-doc, если Вам требуется
документация по API и примеры программирования с использованием
данного модуля.
%endif

%prep
%setup

%build
%python3_build

%if_with doc_package
pushd doc
make html
popd
%endif

%install
%python3_install
%python3_prune

%files
%doc CHANGELOG.rst CONTRIBUTING.rst INSTALL.rst README.rst
%python3_sitelibdir/OpenSSL/
%python3_sitelibdir/%oname-*.egg-info

%if_with doc_package
%files doc
%doc examples
%doc doc/html/*
%endif

%changelog
