%define oname openstackdocstheme
# checking theme is quite strange
%def_without check
%def_with docs

Name: python3-module-%oname
Version: 3.1.1
Release: alt1

Summary: OpenStack Docs Theme

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/openstackdocstheme

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 2.0.0

%if_with docs
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-dulwich >= 0.15.0
BuildRequires: python3-module-hacking >= 3.0.1
BuildRequires: python3-module-pre-commit >= 2.6.0
%endif

%description
OpenStack Sphinx Theme

Theme and extension support for Sphinx documentation that is published to
docs.openstack.org. Intended for use by OpenStack projects.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

# Move theme files to proper location
# somehow they aren't installed automatically
mv %oname/theme %buildroot%python3_sitelibdir/%oname/theme

%if_with docs
# install man page
install -pDm 644 man/%oname.1 %buildroot%_man1dir/%oname.1
%endif

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%_bindir/docstheme-build-pdf
%_bindir/docstheme-build-translated.sh
%_bindir/docstheme-lang-display-name.py
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/%oname.1.xz
%endif

%changelog
