%define oname os-vif
%def_without check
%def_with docs

Name: python3-module-%oname
Version: 3.2.0
Release: alt1.2

Summary: A library for plugging and unplugging virtual interfaces in OpenStack

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/os-vif

Source: %oname-%version.tar
Source1: %oname.watch

Patch: os-vif_allow_external_import.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-oslo.concurrency >= 3.20.0
BuildRequires: python3-module-oslo.config >= 5.1.0
BuildRequires: python3-module-oslo.log >= 3.30.0
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-oslo.privsep >= 1.23.0
BuildRequires: python3-module-oslo.versionedobjects >= 1.28.0
BuildRequires: python3-module-ovsdbapp >= 0.12.1
BuildRequires: python3-module-stevedore >= 1.20.0
BuildRequires: python3-module-debtcollector >= 1.19.0

%if_with check
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-oslotest >= 1.10.0
BuildRequires: python3-module-openvswitch >= 2.9.2
BuildRequires: python3-module-stestr >= 3.1.0
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-netaddr >= 0.7.18
BuildRequires: python3-module-pyroute2 >= 0.5.2
BuildRequires: python3-module-futurist >= 1.2.0
BuildRequires: python3-module-tzdata >= 2022.4
%endif

%if_with docs
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-openstackdocstheme >= 2.2.1
%endif

%description
A library for plugging and unplugging virtual interfaces in OpenStack.
Features:
- A base VIF plugin class that supplies a plug() and unplug() interface
- Versioned objects that represent a virtual interface and its components

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version
%patch -p2

# reno is not used, after openstack moved on openstackdocstheme
find . -name "conf.py" | xargs sed -i '/reno/d'

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/os_vif.1 %buildroot%_man1dir/%oname.1
%endif

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
%__python3 -m stestr run --exclude-regex ".tests.functional"

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/os_vif
%python3_sitelibdir/vif_plug_linux_bridge
%python3_sitelibdir/vif_plug_noop
%python3_sitelibdir/vif_plug_ovs
%python3_sitelibdir/os_vif-%version.dist-info
%exclude %python3_sitelibdir/os_vif/tests
%exclude %python3_sitelibdir/vif_plug_linux_bridge/tests
%exclude %python3_sitelibdir/vif_plug_noop/tests
%exclude %python3_sitelibdir/vif_plug_ovs/tests

%files tests
%python3_sitelibdir/os_vif/tests
%python3_sitelibdir/vif_plug_linux_bridge/tests
%python3_sitelibdir/vif_plug_noop/tests
%python3_sitelibdir/vif_plug_ovs/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/%oname.1.xz
%endif

%changelog
