%define oname oslo.messaging
%def_with check
%def_with docs

Name: python3-module-%oname
Epoch: 1
Version: 16.1.0
Release: alt1.1

Summary: OpenStack Oslo Messaging API

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.messaging

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

Provides: python3-module-oslo-messaging = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-oslo.config >= 5.2.0
BuildRequires: python3-module-oslo.log >= 3.36.0
BuildRequires: python3-module-oslo.utils >= 3.37.0
BuildRequires: python3-module-oslo.serialization >= 2.18.0
BuildRequires: python3-module-oslo.service >= 1.24.0
BuildRequires: python3-module-oslo.middleware >= 3.31.0
BuildRequires: python3-module-oslo.metrics >= 0.2.1
BuildRequires: python3-module-stevedore >= 1.20.0
BuildRequires: python3-module-debtcollector >= 1.2.0
BuildRequires: python3-module-cachetools >= 2.0.0
BuildRequires: python3-module-webob
BuildRequires: python3-module-yaml >= 3.12
BuildRequires: python3-module-amqp >= 2.5.2
BuildRequires: python3-module-kombu >= 4.6.6

%if_with check
BuildRequires: python3-module-kafka
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-hacking >= 6.1.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-pifpaf >= 2.2.0
BuildRequires: python3-module-confluent-kafka >= 1.3.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-eventlet >= 0.23.0
BuildRequires: python3-module-oslo.context >= 5.3.0
BuildRequires: python3-module-futurist >= 1.2.0
BuildRequires: python3-module-greenlet >= 0.4.15
%endif

%if_with docs
BuildRequires: python3-module-sphinx >= 1.6.2
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
%endif

%description
The Oslo project intends to produce a python library containing
infrastructure code shared by OpenStack projects. The APIs provided
by the project should be high quality, stable, consistent and generally
useful.

The Oslo messaging API supports RPC and notifications over a number of
different messaging transports.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-messaging-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/oslomessaging.1 %buildroot%_man1dir/oslomessaging.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%_bindir/oslo-messaging-send-notification
%python3_sitelibdir/oslo_messaging
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/oslo_messaging/tests

%files tests
%python3_sitelibdir/oslo_messaging/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/oslomessaging.1.xz
%endif

%changelog
