%define oname pamqp

%def_without docs

%def_with check

Name: python3-module-%oname
Version: 3.3.0
Release: alt1

Summary: RabbitMQ Focused AMQP low-level library
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/pamqp/
Vcs: https://github.com/gmr/pamqp.git

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
%endif

%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx-autodoc-typehints
%endif

%py3_provides %oname

%description
pamqp is a pure-python AMQP 0-9-1 frame encoder and decoder. The aim is
to create a client agnostic python encoder and decoder for general
purpose use.

%if_with docs
%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
pamqp is a pure-python AMQP 0-9-1 frame encoder and decoder. The aim is
to create a client agnostic python encoder and decoder for general
purpose use.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
pamqp is a pure-python AMQP 0-9-1 frame encoder and decoder. The aim is
to create a client agnostic python encoder and decoder for general
purpose use.

This package contains documentation for %oname.
%endif

%prep
%setup

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
sphinx-build-3 docs pickle
sphinx-build-3 docs html
%endif

%install
%pyproject_install

%if_with docs
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
# Fails on ix86 with OverflowError
%pyproject_run_pytest -k"not test_decode_large_timestamp_bytes_consumed \
and not test_decode_large_timestamp_data_type \
and not test_decode_large_timestamp_value"

%files
%doc *.rst LICENSE
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%if_with docs
%exclude %python3_sitelibdir/*/pickle

%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*
%endif

%changelog
