%define _unpackaged_files_terminate_build 1
%define pypi_name pip
%define system_wheels_path %(%__python3 -c 'import os, sys, system_seed_wheels; sys.stdout.write(os.path.dirname(system_seed_wheels.__file__))' 2>/dev/null || echo unknown)

%def_with check

Name: python3-module-%pypi_name
Version: 25.1.1
Release: alt1

Summary: The PyPA recommended tool for installing Python packages
License: MIT
Group: Development/Python3
Url: https://pip.pypa.io
VCS: https://github.com/pypa/pip.git

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
%add_findprov_skiplist %python3_sitelibdir/pip/_vendor/*
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

# namespace package for system seed wheels which will be used within venv
# created by virtualenv
BuildRequires: python3(system_seed_wheels)

%if_with check
# used in tests/functional/test_vcs_git.py
BuildRequires: /usr/bin/git

%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

Obsoletes: python3-module-pip-pickles
%description
%summary

%package wheel
Summary: %summary
Group: Development/Python3
%py3_requires system_seed_wheels

%description wheel
%summary

Packaged as wheel. Provides the seed package for virtualenv.

%package -n pip
Summary: Executable for PIP
Group: Development/Python3
Requires: python3-module-pip
Obsoletes: python3-module-pip <= 21.2.1-alt2
Conflicts: python3-module-pip <= 21.2.1-alt2

BuildArch: noarch

%description -n pip
%summary

%prep
%setup
%autopatch -p1

# remove bundled exes
rm -f ./src/pip/_vendor/distlib/*.exe

# never unbundle vendored packages
# built wheel being installed into virtualenv will lack of unbundled packages

%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile tests/requirements.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

# since we package python modules as arch dependent
%if "%python3_sitelibdir" != "%python3_sitelibdir_noarch"
mkdir -p %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
%endif

# drop deprecated ntlm support
rm -v %buildroot%python3_sitelibdir/pip/_vendor/urllib3/contrib/ntlmpool.py

# package a built wheel (will be used within venv created by virtualenv)
built_wheel=$(cat ./dist/.wheeltracker) || \
        { echo Make sure you built a pyproject ; exit 1 ; }
mkdir -p "%buildroot%system_wheels_path"
cp -t "%buildroot%system_wheels_path/" "./dist/$built_wheel"

%check
export NO_LATEST_WHEELS=YES
%pyproject_run_pytest -vra -m 'not network and unit'

%files -n pip
%_bindir/pip

%files
%doc README.*
%_bindir/pip3
%python3_sitelibdir/pip/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%files wheel
%system_wheels_path/%{pep427_name %pypi_name}-%version-*.whl

%changelog
