%define pypi_name precis-i18n
%define mod_name precis_i18n

Name:    python3-module-%mod_name
Version: 1.1.1
Release: alt1

Summary: Python3 implementation of PRECIS framework (RFC 8264, RFC 8265, RFC 8266)

License: MIT
Group:   Development/Python3
URL:     https://pypi.org/project/precis-i18n
VCS:     https://github.com/byllyfish/precis_i18n

Source:  %name-%version.tar

Packager: Grigory Ustinov <grenka@altlinux.org>
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-python3
# build backend and its deps
BuildRequires: python3-module-setuptools

BuildArch: noarch

%description
If you want your application to accept unicode user names and passwords,
you must be careful in how you validate and compare them. The PRECIS framework
makes internationalized user names and passwords safer for use by applications.
PRECIS profiles transform unicode strings into a canonical form,
suitable for comparison.

This module implements the PRECIS Framework as described in:

- PRECIS Framework: Preparation, Enforcement, and Comparison of
Internationalized Strings in Application Protocols (RFC 8264)
- Preparation, Enforcement, and Comparison of Internationalized Strings
Representing Usernames and Passwords (RFC 8265)
- Preparation, Enforcement, and Comparison of Internationalized Strings
Representing Nicknames (RFC 8266)

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_unittest -v

%files
%doc LICENSE.txt *.md
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
