%define pypi_name pymediainfo
%def_enable check

Name: python3-module-%pypi_name
Version: 6.1.0
Release: alt1

Summary: A Python 3 wrapper for the mediainfo library
Group: Development/Python3
License: MIT
Url: https://pypi.python.org/pypi/%pypi_name
Source: https://pypi.io/packages/source/p/%pypi_name/%pypi_name-%version.tar.gz

BuildArch: noarch

Requires: libmediainfo

%define python3_ver 3.7

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel >= %python3_ver python3-module-wheel python3-module-setuptools_scm
%{?_enable_check:BuildRequires: python3-module-tox python3-module-pytest-xdist libmediainfo
BuildRequires: python3(mypy) python3(pylint)}

%description
This Python3 module provides a wrapper around the MediaInfo library.

%prep
%setup -n %pypi_name-%version

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check

%files
%python3_sitelibdir_noarch/%pypi_name/
%python3_sitelibdir_noarch/%{pyproject_distinfo %pypi_name}
%doc README.rst


%changelog
