%define oname OpenGL
%define pypi_name PyOpenGL
%define pypi_name_accelerate PyOpenGL-accelerate
%define modulename python3-module-%oname

# Fatal Python error: Segmentation fault
%ifnarch ppc64le
%def_with check
%else
%def_without check
%endif

Name: python3-module-pyopengl
Version: 3.1.9
Release: alt2.1

Summary: Metapackage including python modules for OpenGL library

Group: Development/Python3
License: BSD-3-Clause
Url: http://pyopengl.sourceforge.net

# https://pypi.org/project/PyOpenGL
# https://pypi.org/project/PyOpenGL-accelerate
# https://github.com/mcfletch/pyopengl
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-Cython
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pygame
BuildRequires: python3-module-psutil
BuildRequires: python3-module-xlib
BuildRequires: libOSMesa-devel
BuildRequires: libfreeglut-devel
BuildRequires: xvfb-run
BuildRequires: /proc
%endif

%description
OpenGL bindings for Python including support for GL extensions,
GLU, WGL, GLUT, GLE, and Tk

%package -n %modulename
Summary: A Python module for interfacing with the OpenGL library
Group: Development/Python3
BuildArch: noarch
%add_python3_req_skip OpenGL.GLES3.OES
%add_python3_req_skip OpenGL.raw.DISABLED
%add_python3_req_skip OpenGL.raw.DISABLED._types
%add_python3_req_skip OpenGL.raw.GLSC2
%add_python3_req_skip OpenGL.raw.GLSC2._types
# mapping from PyPI name
Provides: python3-module-%{pep503_name %pypi_name} = %EVR

%description -n %modulename
OpenGL bindings for Python including support for GL extensions,
GLU, WGL, GLUT, GLE, and Tk

%package -n %modulename-tk
Summary: %oname Python3 Tk widget
Group: Development/Python3
Requires: %modulename = %EVR
%py3_requires tkinter
BuildArch: noarch

%description -n %modulename-tk
%oname Togl (Tk OpenGL widget) 1.6 support for Python3

%package -n %{modulename}_accelerate
Summary: Acceleration code for PyOpenGL
Group: Development/Python3

%description -n %{modulename}_accelerate
This set of C (Cython) extensions provides acceleration of common
operations for slow points in PyOpenGL 3.x.

%prep
%setup

find tests -type f -name '*.py' -exec \
	sed -i 's|#! %_bindir/env python|#!%_bindir/python3|' '{}' +

# Force recythonize it please!
find accelerate/src/ -name "*.c" | xargs rm -fv

%build
%pyproject_build
pushd accelerate
%pyproject_build
popd

%install
%pyproject_install
pushd accelerate
%pyproject_install
popd

%check
export PYTHONPATH=%buildroot%python3_sitelibdir_noarch:%buildroot%python3_sitelibdir
# https://github.com/mcfletch/pyopengl/issues/141
# https://github.com/mcfletch/pyopengl/issues/142
xvfb-run -a -s "-screen 0 1024x768x24 -ac +extension GLX +render -noreset" py.test-3 tests \
    -k 'not test_check_egl_es1 and not test_check_egl_es2 and not test_egl_ext_enumerate and not test_glCallLists_twice2'
xvfb-run -a -s "-screen 0 1024x768x24 -ac +extension GLX +render -noreset" py.test-3 accelerate/tests

%files -n %modulename
%doc license.txt readme.rst
%python3_sitelibdir_noarch/%oname
%python3_sitelibdir_noarch/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir_noarch/%oname/Tk

%files -n %modulename-tk
%python3_sitelibdir_noarch/%oname/Tk

%files -n %{modulename}_accelerate
%doc license.txt readme.rst
%python3_sitelibdir/%{oname}_accelerate
%python3_sitelibdir/%{pyproject_distinfo %pypi_name_accelerate}/

%changelog
