%define _unpackaged_files_terminate_build 1
%define pypi_name pyquery

%def_with check

Name: python3-module-%pypi_name
Version: 2.0.0
Release: alt3

Summary: A jQuery-like library for python
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/pyquery/
Vcs: https://github.com/gawel/pyquery

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-cssselect
BuildRequires: python3-module-lxml
BuildRequires: python3-module-webtest
BuildRequires: python3-module-pytest
%endif

%description
%name allows you to make jQuery queries on XML documents.  The API is as much
as possible the similar to jQuery.  %name uses lxml for fast XML and HTML
manipulation.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
# test_selector_html uses XML namespaces, which are broken with libxml2 2.10.4+
# python3.12 https://github.com/gawel/pyquery/issues/249
%pyproject_run_pytest -v \
--deselect=pyquery/pyquery.py::pyquery.pyquery.PyQuery.serialize_dict \
-k 'not test_get and not test_selector_html'

%files
%doc *.rst *.txt
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%pypi_name-%version.dist-info

%changelog
