%define  modulename pyrad

%def_with check

Name:    python3-module-%modulename
Version: 2.4
Release: alt4

Summary: Python RADIUS Implementation
License: BSD-3-Clause
Group:   Development/Python3
URL:     https://github.com/pyradius/pyrad

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-poetry
%if_with check
BuildRequires: python3-module-netaddr
BuildRequires: python3-module-six
%endif

BuildArch: noarch

Source:  %modulename-%version.tar
Patch: refactor-test-aliases-for-python3.11-compat.patch

%description
pyrad is an implementation of a RADIUS client as described in RFC2865. It takes
care of all the details like building RADIUS packets, sending them and
decoding responses.

%prep
%setup -n %modulename-%version
%patch -p1

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_unittest

%files
%python3_sitelibdir/%modulename/
%python3_sitelibdir/%{pyproject_distinfo %modulename}
%exclude %python3_sitelibdir/example
%doc *.rst

%changelog
