%define oname pyresttest

%def_with check

Name: python3-module-%oname
Version: 1.7.1
Release: alt3

Summary: Python RESTful API Testing & Microbenchmarking Tool
License: ASLv2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/pyresttest/
VCS: https://github.com/svanoort/pyresttest.git

Source: %name-%version.tar
Patch: use-system-six-alt-fix.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pyaml
BuildRequires: python3-module-pycurl
BuildRequires: python3-module-future
BuildRequires: python3-module-six
%endif

Requires: python3-module-future

%py3_provides %oname

%description
* A simple but powerful REST testing and benchmarking framework
* Minimal dependencies, designed to slot into automated configuration
  management/orchestration tools
* Tests are defined in basic YAML or JSON config files, no code needed
* Logic is written and extensible in Python

%prep
%setup
%patch -p1

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
%__python3 -m unittest discover -v

%files
%doc *.md
%_bindir/*
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info


%changelog
