%define oname pytest-services

Name: python3-module-%oname
Version: 2.2.1
Release: alt3

Summary: Services plugin for pytest testing framework

License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/pytest-services/

# Source-git: https://github.com/pytest-dev/pytest-services.git
Source: %name-%version.tar
Patch: support-python3.12.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro

BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-pytest-cov python3-module-tox

# generated by 'epm restore --dry-run' from python3-module-pytest-services/setup.py install_requires
%py3_use requests
%py3_use psutil
%py3_use pytest
%py3_use zc.lockfile >= 2.0


%py3_provides pytest_services
%py3_requires requests psutil
# we have several versions of Django
# so, we cannot rely on auto-requires
%filter_from_requires /^python3(django\(\..*\)\?)/d

%description
The plugin provides a set of fixtures and utility functions to start
service processes for your tests with pytest.

%prep
%setup
%patch -p1

# Added by upstream in initial commit, 10 years didn't removed ¯\_(ツ)_/¯
rm -v pytest_services/gui.py.orig

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_install

%check
py.test3 -vv --fixtures tests

%files
%doc *.rst docs/*.rst docs/api
%python3_sitelibdir/*

%changelog
