%define oname rabbitpy

%def_with check

Name: python3-module-%oname
Version: 2.0.1
Release: alt3

Summary: A pure python, thread-safe, minimalistic and pythonic RabbitMQ client library
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/rabbitpy/
Vcs: https://github.com/gmr/rabbitpy.git


Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pamqp
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-mock
%endif

%description
A pure python, thread-safe, minimalistic and pythonic BSD Licensed
AMQP/RabbitMQ library that supports Python 2.6+ and Python 3.2+.
rabbitpy aims to provide a simple and easy to use API for interfacing
with RabbitMQ, minimizing the programming overhead often found in other
libraries.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
A pure python, thread-safe, minimalistic and pythonic BSD Licensed
AMQP/RabbitMQ library that supports Python 2.6+ and Python 3.2+.
rabbitpy aims to provide a simple and easy to use API for interfacing
with RabbitMQ, minimizing the programming overhead often found in other
libraries.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
A pure python, thread-safe, minimalistic and pythonic BSD Licensed
AMQP/RabbitMQ library that supports Python 2.6+ and Python 3.2+.
rabbitpy aims to provide a simple and easy to use API for interfacing
with RabbitMQ, minimizing the programming overhead often found in other
libraries.

This package contains documentation for %oname.

%prep
%setup

sed -i 's|sphinx-build|&-3|' docs/Makefile

%build
%pyproject_build

%install
%pyproject_install

%make -C docs pickle
%make -C docs html

cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/

%check
%pyproject_run_pytest -v

%files
%doc *.rst examples
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/*/pickle

%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*

%changelog
