%define oname rpyc

%def_with check

Name: python3-module-%oname
Version: 6.0.0
Release: alt1

Summary: Remote Python Call (RPyC), a transparent and symmetric RPC library
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/rpyc/
Vcs: https://github.com/tomerfiliba-org/rpyc

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-sphinx_rtd_theme
BuildRequires: python3-module-sphinx
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-plumbum
%endif

%py3_provides %oname

%description
RPyC (pronounced like are-pie-see), or Remote Python Call, is a
transparent library for symmetrical remote procedure calls, clustering,
and distributed-computing. RPyC makes use of object-proxying, a
technique that employs python's dynamic nature, to overcome the physical
boundaries between processes and computers, so that remote objects can
be manipulated as if they were local.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
RPyC (pronounced like are-pie-see), or Remote Python Call, is a
transparent library for symmetrical remote procedure calls, clustering,
and distributed-computing. RPyC makes use of object-proxying, a
technique that employs python's dynamic nature, to overcome the physical
boundaries between processes and computers, so that remote objects can
be manipulated as if they were local.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
RPyC (pronounced like are-pie-see), or Remote Python Call, is a
transparent library for symmetrical remote procedure calls, clustering,
and distributed-computing. RPyC makes use of object-proxying, a
technique that employs python's dynamic nature, to overcome the physical
boundaries between processes and computers, so that remote objects can
be manipulated as if they were local.

This package contains documentation for %oname.

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

sed -i 's|#!/usr/bin/env python.*|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%pyproject_build

%install
%pyproject_install

%make -C docs pickle
%make -C docs html

cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/

%check
export PYTHONPATH=$PWD/tests/
%pyproject_run_pytest -v -k "\
not test_close_timeout \
and not test_close_timeout_default_none \
and not test_deploy \
and not test_api \
and not test_pruning \
and not test_pinned_to_0 \
and not test_listing"

%files
%doc *.rst
%_bindir/*
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}
%exclude %python3_sitelibdir/%oname/pickle

%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname/pickle

%files docs
%doc docs/_build/html demos


%changelog
