# -*- mode: rpm-spec; coding: utf-8 -*-
%define oname serial

%def_without doc_package
%def_without jython

Name: python3-module-%oname
Version: 3.5
Release: alt2
Summary: Serial port access for python
Summary(ru_RU.UTF-8): Доступ к последовательному порту из python
# https://github.com/pyserial/pyserial
Source: %name-%version.tar
License: Python
Group: Development/Python3
Prefix: %_prefix
Url: https://github.com/pyserial/pyserial
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
%add_python3_req_skip System clr

Conflicts: python-module-%oname
Obsoletes: python-module-%oname

%description
pyserial capsulates the access for the serial port. It provides
backends for standard Python running on Windows, Linux, BSD (possibly
any POSIX compilant system) and Jython. The module automaticaly
selects the appropriate backend.

This module contains POSIX compatible serial port access.
It's built for python %_python_version

%description -l ru_RU.UTF-8
С помощью модулей pyserial можно работать с последовательным портом в
стандартном Python, запущенном на Windows, Linux, BSD (возможно, любой
POSIX-совместимой системе) или Jython. Модуль автоматически выбирает
подходящий для данной системы механизм доступа.

Этот модуль содержит методы доступа к последовательному порту, пригодные
для POSIX-совместимых систем.
Он собран для Python версии %_python_version

%if_with jython
%package jython
Summary: Jython compatible serial port access
Group: Development/Python3

%description jython
This module capsulates the access for the serial port. It provides
backends for standard Python running on Windows, Linux, BSD (possibly
any POSIX compilant system) and Jython. The module automaticaly
selects the appropriate backend.

This module contains Jython compatible serial port access.
It's built for python %__python_version
%endif

%prep
%setup

%build
echo "*** Creating package %name ***"
%python3_build

%install
%python3_build_install --optimize=2

%files
%doc CHANGES.rst README.rst LICENSE.txt
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/serial/*java.py*
%exclude %python3_sitelibdir/serial/__pycache__/*java.*
%exclude %python3_sitelibdir/serial/*win32.py*
%exclude %python3_sitelibdir/serial/__pycache__/*win32.*
%exclude %python3_sitelibdir/serial/tools/*windows.py*
%exclude %python3_sitelibdir/serial/tools/__pycache__/*windows.*
%exclude %python3_sitelibdir/serial/serialcli.py*
%exclude %python3_sitelibdir/serial/__pycache__/serialcli.*
%doc examples

%if_with jython
%files jython
%python3_sitelibdir/serial/*java.py*
%endif

%changelog
