%define _unpackaged_files_terminate_build 1
%define pypi_name sh
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 2.0.6
Release: alt1
Summary: Python subprocess replacement
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/sh/
Vcs: https://github.com/amoffat/sh
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter coveralls
%add_pyproject_deps_check_filter rstcheck
%add_pyproject_deps_check_filter sphinx-rtd-theme
%pyproject_builddeps_metadata
%pyproject_builddeps_check
BuildRequires: /dev/pts
BuildRequires: /proc
%endif

%description
sh is a full-fledged subprocess replacement for Python that allows you to call
any program as if it were a function:

  from sh import ifconfig
  print(ifconfig("eth0"))

sh is not a collection of system commands implemented in Python.

sh relies on various Unix system calls and only works on Unix-like operating
systems - Linux, macOS, BSDs etc. Specifically, Windows is not supported.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_poetry dev
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
export SH_TESTS_RUNNING=1
%pyproject_run_pytest -ra -Wignore

%files
%doc README.*
%python3_sitelibdir/%mod_name.py
%python3_sitelibdir/__pycache__/%mod_name.*
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
