%define oname shapely
%define mod_name %oname

%def_with check
# Need module numpydoc and bootstrapped package
%def_without doc

Name: python3-module-%oname
Version: 2.0.7
Release: alt1

Summary: Planar geometries, predicates, and operations
License: BSD-3-Clause
Group: Development/Python3

URL: https://pypi.org/project/shapely
VCS: https://github.com/shapely/shapely
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3 rpm-macros-sphinx3
BuildRequires: libgeos-devel
# build backend and its deps
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-Cython libnumpy-py3-devel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-numpy-testing
%endif
%if_with doc
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinxcontrib-websupport
BuildRequires: python3(matplotlib.sphinxext)
BuildRequires: %name = %version
%endif

%description
Planar geometries, predicates, and operations.

%package examples
Summary: Examples for %oname
Group: Development/Python3
Requires: %name = %EVR

%description examples
Planar geometries, predicates, and operations.

This package contains examples for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3
%add_python3_req_skip figures

%description pickles
Planar geometries, predicates, and operations.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Planar geometries, predicates, and operations.

This package contains documentation for %oname.

%prep
%setup

# workaround for versioneer
rm versioneer.py
grep -qsF ' export-subst' .gitattributes || exit 1
vers_f="$(sed -n 's/ export-subst//p' .gitattributes)"
echo 'def get_versions():return {"version": "%version"}' > "$vers_f"
echo 'def get_cmdclass(): return {}' > versioneer.py
echo 'def get_version(): return "%version"' >> versioneer.py

%if_with doc
%prepare_sphinx3 .
ln -s ../objects.inv docs/
sed -i 's/sphinx-apidoc/sphinx-apidoc-3/' docs/Makefile
%endif

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%if_with doc
%make SPHINXBUILD="sphinx-build-3" -C docs pickle
%make SPHINXBUILD="sphinx-build-3" -C docs html

cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
# .github/workflows/tests.yml
%pyproject_run -- pytest -vra --pyargs %mod_name.tests

%files
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%if_with doc
%exclude %python3_sitelibdir/*/pickle
%endif

%if_with doc
%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*
%endif

%changelog
