%define _unpackaged_files_terminate_build 1
%define pypi_name stdlibs

%def_with check

Name: python3-module-%pypi_name
Version: 2024.10.25
Release: alt1
Summary: List of packages in the stdlib
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/stdlibs
Vcs: https://github.com/omnilib/stdlibs
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
# not packaged in sisyphus
%add_pyproject_deps_check_filter attribution
%add_pyproject_deps_check_filter fissix
%pyproject_builddeps_metadata_extra dev
%endif

%description
Simple list of top-level packages in Python's stdlib.

Note: If you only need the live module names on 3.10+, just use
sys.stdlib_module_names. This is not exactly a backport, but a static list of
those for most useful Python versions.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

# don't package tests
rm -r %buildroot%python3_sitelibdir/%pypi_name/tests/

%check
%pyproject_run -- python -m %pypi_name.tests -v

%files
%doc README.md
%python3_sitelibdir/stdlibs/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
