%define modname tablib
%def_enable check
%if_enabled check
%def_enable extra_check
%else
%def_disable extra_check
%endif
%def_enable docs

Name:		python3-module-%modname
Version:	3.8.0
Release:	alt1
Summary:	Format agnostic tabular data library (XLS, JSON, YAML, CSV)

Group:		Development/Python3
License:	MIT
URL:		https://github.com/jazzband/tablib.git
Source0:	%name-%version.tar

BuildArch:	noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pyproject-installer python3(setuptools) python3(wheel)
BuildPreReq: python3-module-html5lib python3-module-pbr python3-module-yaml
%{?_enable_check:BuildRequires: python3(pytest) python3(pytest-cov) python3(openpyxl) python3(tabulate) python3(xlrd) python3(xlwt) python3(odf)}
%{?_enable_extra_check:BuildRequires: python3(pandas)}
%{?_enable_docs:BuildRequires: python3-module-sphinx python3-module-setuptools_scm}


%description
Tablib is a format-agnostic tabular dataset library, written in Python.

Output formats supported:

 - Excel (Sets + Books)
 - JSON (Sets + Books)
 - YAML (Sets + Books)
 - HTML (Sets)
 - TSV (Sets)
 - CSV (Sets)


%prep
%setup

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%if_enabled docs
env PYTHONPATH="$PWD/src" sphinx-build-3 docs html
env PYTHONPATH="$PWD/src" sphinx-build-3 -b man docs man
rm -rf html/.{buildinfo,doctrees}
%endif

%install
%pyproject_install
%{?_enable_docs:install -pDm 644 man/%modname.1 %buildroot%_man1dir/%modname.1}

%check
%pyproject_run_pytest -v

%files
%doc README.md AUTHORS LICENSE HISTORY.md CODE_OF_CONDUCT.md RELEASING.md
%if_enabled docs
%doc html
%_man1dir/%{modname}*
%endif
%python3_sitelibdir/%{modname}*


%changelog
