%define oname websocket-client

%def_with check

Name: python3-module-%oname
Version: 1.8.0
Release: alt1

Summary: WebSocket client for Python with low level API options

License: Apache-2.0
Group: Development/Python3
URL: https://pypi.org/project/websocket-client
VCS: https://github.com/websocket-client/websocket-client

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3-module-pytest
%endif

%py3_provides websocket

BuildArch: noarch

%description
websocket-client is a WebSocket client for Python.  It provides access to low
level APIs for WebSockets.  websocket-client implements version hybi-13 of the
WebSocket protocol. This client does not currently support the
permessage-deflate extension from RFC 7692.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
websocket-client is a WebSocket client for Python.  It provides access to low
level APIs for WebSockets.  websocket-client implements version hybi-13 of the
WebSocket protocol. This client does not currently support the
permessage-deflate extension from RFC 7692.

This package contains tests for %oname.

%prep
%setup

%build
%python3_build

%install
%python3_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-3 -v websocket/tests

%files
%doc LICENSE ChangeLog *.md
%_bindir/wsdump
%python3_sitelibdir/websocket
%python3_sitelibdir/websocket_client-%version-py%_python3_version.egg-info
%exclude %python3_sitelibdir/*/tests

%files tests
%python3_sitelibdir/*/tests

%changelog
