%define _unpackaged_files_terminate_build 1
%define oname webtest

%def_with check

Name: python3-module-%oname
Version: 3.0.4
Release: alt1.1
Summary: Helper to test WSGI applications
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/WebTest/
Vcs: https://github.com/Pylons/webtest.git

Source: %name-%version.tar
Patch0: %name-%version-alt.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3(bs4)
BuildRequires: python3(mock)
BuildRequires: python3(PasteDeploy)
BuildRequires: python3(pytest)
BuildRequires: python3(waitress)
BuildRequires: python3(webob)
BuildRequires: python3(wsgiproxy)
BuildRequires: python3(pyquery)
%endif

%description
This wraps any WSGI application and makes it easy to send test
requests to that application, without starting up an HTTP server.

This provides convenient full-stack testing of applications written
with any WSGI-compatible framework.

This is based on ``paste.fixture.TestApp``.

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v

%files
%python3_sitelibdir/webtest/
%python3_sitelibdir/%{pyproject_distinfo %oname}/

%changelog
