%define _unpackaged_files_terminate_build 1

%define mod_name winrm
%define pypi_name pywinrm

%def_with check

Name:       python3-module-%mod_name
Version:    0.4.3
Release:    alt2

Summary:    Python library for Windows Remote Management
License:    MIT
Group:      Networking/Remote access
Url:        https://pypi.python.org/pypi/pywinrm
BuildArch:  noarch

# Source-git: https://github.com/diyan/%pypi_name.git
Source0:    %name-%version.tar
Source1:    winexe_py3winrm

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

# requests.packages reexport urllib3, but without package provides
%add_python3_req_skip requests.packages.urllib3

# generated by epm --restore --dry-run from winrm/setup.py install_requires
%py3_use xmltodict
%py3_use requests >= 2.9.1
#py3_use requests-ntlm >= 0.3.0
%py3_use six

%if_with check
# generated by epm --restore --dry-run from winrm/requirements-test.txt
%py3_buildrequires pytest >= 4.4.2
%py3_buildrequires mock >= 3.0.5
%endif

%py3_provides %pypi_name

# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR

%description
%pypi_name is a Python client for the Windows Remote Management (WinRM)
service. WinRM allows you to perform various management tasks
remotely. These include, but are not limited to: running batch
scripts, powershell scripts, and fetching WMI variables.

To try it out, you can run the included winexe_py3winrm script
(needs Python3) or consider the following usage example:

import winrm

s = winrm.Session('windows-host.example.com', auth=('john.smith', 'secret'))
r = s.run_cmd('ipconfig', ['/all'])

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

mkdir -p %buildroot%_bindir
install -m755 %SOURCE1 -t %buildroot%_bindir

# don't package tests(useless)
rm -r %buildroot%python3_sitelibdir/%mod_name/tests/

%check
py.test3 -v winrm/tests/

%files
%python3_sitelibdir/winrm/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%_bindir/*py3*


%changelog
