%define oname wrapt

%def_with check

Name: python3-module-%oname
Version: 1.16.0
Release: alt1

Summary: A Python module for decorators, wrappers and monkey patching

License: BSD-2-Clause
Group: Development/Python3
URL: https://pypi.org/project/wrapt
VCS: https://github.com/GrahamDumpleton/wrapt

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3 rpm-macros-sphinx3
BuildRequires: python3-devel python3-module-pytest
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx_rtd_theme

%py3_provides %oname

%description
The aim of the wrapt module is to provide a transparent object proxy for
Python, which can be used as the basis for the construction of function
wrappers and decorator functions.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
The aim of the wrapt module is to provide a transparent object proxy for
Python, which can be used as the basis for the construction of function
wrappers and decorator functions.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
The aim of the wrapt module is to provide a transparent object proxy for
Python, which can be used as the basis for the construction of function
wrappers and decorator functions.

This package contains documentation for %oname.

%prep
%setup

%prepare_sphinx3 .
ln -s ../objects.inv docs/

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%install
%python3_install

%make SPHINXBUILD="sphinx-build-3" -C docs pickle
%make SPHINXBUILD="sphinx-build-3" -C docs html

cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test3

%files
%doc LICENSE README.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/*.egg-info
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build/html blog

%changelog
