%define _unpackaged_files_terminate_build 1
%define pypi_name yamllint

%def_with check
%def_with docs

Name: python3-module-%pypi_name
Version: 1.35.1
Release: alt1
Summary: A linter for YAML files
License: GPLv3
Group: Development/Python
Url: https://pypi.org/project/yamllint/
Vcs: https://github.com/adrienverge/yamllint
BuildArch: noarch
Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Provides: yamllint = %EVR
Obsoletes: yamllint <= 1.24.2-alt1

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: /dev/pts
%pyproject_builddeps_metadata
%endif

%if_with docs
BuildRequires: python3-module-sphinx_rtd_theme
%endif

BuildRequires: python3-module-sphinx-sphinx-build-symlink

%description
A linter for YAML files.

yamllint does not only check for syntax validity, but for weirdnesses like key
repetition and cosmetic problems such as lines length, trailing spaces,
indentation, etc.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%if_with docs
# man page
pushd docs
make man
popd
%endif

%install
%pyproject_install

%if_with docs
# man page
install -D -m0644 docs/_build/man/yamllint.1 %buildroot/%_man1dir/yamllint.1
%endif

%check
%pyproject_run_unittest discover

%files
%doc README.rst CHANGELOG.rst
%if_with docs
%_man1dir/yamllint.1.*
%endif

%_bindir/yamllint
%python3_sitelibdir/yamllint/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
