%define _unpackaged_files_terminate_build 1

%define pypi_name zope.hookable
%define ns_name zope
%define mod_name hookable

%def_with check

Name: python3-module-%pypi_name
Version: 7.0
Release: alt1.1
Summary: Hookable object support
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.hookable/
Vcs: http://github.com/zopefoundation/zope.hookable
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
%py3_requires zope
# setuptools(pkg_resources) is used by namespace root that is packaged
# separately at python3-module-zope
%add_pyproject_deps_runtime_filter setuptools
%pyproject_runtimedeps_metadata
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
%endif

%description
This package supports the efficient creation of "hookable" objects, which are
callable objects that are meant to be optionally replaced.

The idea is that you create a function that does some default thing and make it
hookable. Later, someone can modify what it does by calling its sethook method
and changing its implementation. All users of the function, including those that
imported it, will see the change.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

# strip devel files
rm %buildroot%python3_sitelibdir/%ns_name/%mod_name/*.c

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt *.rst
%python3_sitelibdir/%ns_name/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%python3_sitelibdir/%pypi_name-%version-py%_python3_version-nspkg.pth
%exclude %python3_sitelibdir/%ns_name/%mod_name/tests/

%changelog
