%define _unpackaged_files_terminate_build 1

%define pypi_name zope.i18n
%define ns_name zope
%define mod_name i18n

%def_with check

Name: python3-module-%pypi_name
Version: 5.2
Release: alt1.1
Summary: Zope Internationalization Support
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.i18n/
Vcs: https://github.com/zopefoundation/zope.i18n.git
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# setuptools(pkg_resources) is used by namespace root that is packaged
# separately at python3-module-zope
%add_pyproject_deps_runtime_filter setuptools
%pyproject_runtimedeps_metadata
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
# zope.component.testing is subpackaged
BuildRequires: python3-module-zope.component-tests
%endif

%description
This package implements several APIs related to internationalization and
localization.

* Locale objects for all locales maintained by the ICU project.
* Gettext-based message catalogs for message strings.
* Locale discovery for Web-based requests.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
export zope_i18n_compile_mo_files=True
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt *.rst
%python3_sitelibdir/%ns_name/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/%ns_name/%mod_name/testing.*
%exclude %python3_sitelibdir/%ns_name/%mod_name/*/testing.*
%exclude %python3_sitelibdir/%ns_name/%mod_name/tests
%exclude %python3_sitelibdir/%ns_name/%mod_name/locales/tests

%changelog
