%define _unpackaged_files_terminate_build 1
%define oname zope.lifecycleevent

%def_with check

Name: python3-module-%oname
Version: 5.1
Release: alt1.1

Summary: Object life-cycle events
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.lifecycleevent
Vcs: https://github.com/zopefoundation/zope.lifecycleevent.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.configuration
BuildRequires: python3-module-zope.component
BuildRequires: python3-module-zope.component-tests
BuildRequires: python3-module-zope.testing
%endif

%py3_requires zope

%description
This package defines a specific set of event objects and API functions for
describing the life-cycle of objects in the system: object creation, object
modification, and object removal.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.configuration zope.testrunner

%description -n python3-module-%oname-tests
This package contains tests for %oname

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -v

%files
%doc *.txt *.rst
%python3_sitelibdir/zope/lifecycleevent
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests.*

%files tests
%python3_sitelibdir/*/*/tests.*


%changelog
