%define pypi_name zope.login
%define ns_name zope
%define mod_name login

%def_with check

Name: python3-module-%pypi_name
Version: 3.1
Release: alt1.1

Summary: Login helpers for zope.publisher / authentication
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.login
VCS: https://github.com/zopefoundation/zope.login

Source: %name-%version.tar
Source1: %pyproject_deps_config_name

# this projects depends on pkg_resources that is subpackaged in ALTLinux
%add_pyproject_deps_runtime_filter setuptools
Requires: python3-module-pkg_resources
%pyproject_runtimedeps_metadata
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
%endif

%description
This package provides a login helpers for zope.publisher based on the
concepts of zope.authentication.

%package tests
Summary: Tests for zope.login
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package provides a login helpers for zope.publisher based on the
concepts of zope.authentication.

This package contains tests for %pypi_name.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
    %buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt *.rst
%python3_sitelibdir/%ns_name/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files tests
%python3_sitelibdir/*/*/tests


%changelog
