%def_with debug

Name: 	 qcad
Version: 3.32.3.4
Release: alt2

Summary: A professional CAD system
Summary(ru_RU.UTF-8): Профессиональная система CAD
License: GPL-3.0 with Qt-GPL-exception-1.0 and CC-BY-3.0 and GPL-2.0+ and MIT and BSD-2-Clause and ALT-Public-Domain
Group:   Graphics

Url: 	 http://www.ribbonsoft.com/qcad.html
# VCS:   https://github.com/qcad/qcad.git
# TODO: remove bundled fonts or specify their licenses  

Packager: Andrey Cherepanov <cas@altlinux.org>

Source0: qcad-%version.tar
Source1: qcadcore_ru.ts
Source2: qcadentity_ru.ts
Source3: scripts_ru.ts

Patch0: %name-%version-%release.patch
Patch1: qcad-alt-use-system-zlib.patch
Patch2: qcad-disable-macos.patch
Patch3: qcad-fix-lto.patch

BuildRequires(pre): rpm-macros-qt5-webengine

BuildRequires: gcc-c++ qt5-base-devel python
BuildRequires: desktop-file-utils
BuildRequires: libdbus-devel
BuildRequires: libGL-devel
BuildRequires: libGLU-devel
BuildRequires: libssl-devel
BuildRequires: qt5-designer
BuildRequires: qt5-imageformats
BuildRequires: qt5-script-devel
BuildRequires: qt5-svg-devel
BuildRequires: qt5-tools-devel
BuildRequires: qt5-tools-devel-static
%ifarch %qt5_qtwebengine_arches
BuildRequires: qt5-webengine-devel
%endif
BuildRequires: qt5-webkit-devel
BuildRequires: qt5-xmlpatterns-devel
BuildRequires: zlib-devel
BuildRequires: libquazip-qt5-devel

Requires: qt5-translations qt5-imageformats

%description
QCad is a professional CAD System. With QCad you can easily construct
and change drawings with ISO-text and many other features and save them
as DXF-files. These DXF-files are the interface to many CAD-systems such
as AutoCAD(TM) and many others.

%description -l ru_RU.UTF-8
QCad это профессиональная CAD система. С QCad вы можете легко создавать
и изменять рисунки с вставленным текстом и сохранять это в DXF файлы.
Через DXF файлы есть возможность обмениваться данными с другими CAD
системами (например, AutoCAD).

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

cp -f %SOURCE1 ts/qcadcore_ru.ts
cp -f %SOURCE2 ts/qcadentity_ru.ts
cp -f %SOURCE3 ts/scripts_ru.ts
rm -f ts/*.qm

rm -rf src/3rdparty/opennurbs/zlib
%if_with debug
echo 'DEFINES -= QT_NO_DEBUG_OUTPUT' >> shared.pri
%endif

%ifarch %e2k
sed -i '/CONFIG += precompile_header/d' src/scripting/ecmaapi/ecmaapi.pro
sed -i '/#include <QString>/i #include <QScriptEngine>' \
	src/scripting/ecmaapi/RScriptHandlerEcma.h
# cpio archive too big - 4622M
%add_optflags -g0
%endif

%build
%qmake_qt5

%define fallback_qt_version 5.15.3
if [ ! -e src/3rdparty/qt-labs-qtscriptgenerator-%_qt5_version ] ; then
    pushd src/3rdparty
    cp -ar qt-labs-qtscriptgenerator-%fallback_qt_version qt-labs-qtscriptgenerator-%_qt5_version
    mv qt-labs-qtscriptgenerator-%_qt5_version/qt-labs-qtscriptgenerator-%fallback_qt_version.pro qt-labs-qtscriptgenerator-%_qt5_version/qt-labs-qtscriptgenerator-%_qt5_version.pro
    popd
fi
# Regenerate all translations
lupdate-qt5 ts/scripts.pro
for pro in ts/scripts.pro src/gui/gui.pro src/entity/entity.pro src/core/core.pro; do lrelease-qt5 ${pro};done
#export NPROCS=1
%make_build

%install
%installqt5
# Main executable
install -Dm755 release/qcad-bin %buildroot%_libdir/%name/qcad-bin

# Make executable wrapper
install -Dm0755 qcad %buildroot%_bindir/qcad

# Libraries
install -d %buildroot%_libdir
cp release/lib*.so %buildroot%_libdir

# Translations
install -d %buildroot%_libdir/%name/ts
cp ts/*.qm %buildroot%_libdir/%name/ts

# Documentation
install -Dm644 readme.txt %buildroot%_libdir/%name/readme.txt

echo other stuff
# Other stuff
cp -a   examples \
	fonts \
	libraries \
	linetypes \
	patterns \
	plugins \
	scripts \
	"%buildroot%_libdir/%name/"

# Desktop file
install -Dm644 qcad.desktop %buildroot%_desktopdir/%name.desktop

# Icon
install -Dm644 ./support/doc/api/qcad_icon.png %buildroot%_iconsdir/hicolor/64x64/apps/org.qcad.QCAD.png

# Add localization fo qcad.lang
for l in $(find %buildroot%_libdir/%name/qm -name \*.qm); do
	echo -n $l | sed 's,.*_\(.*\)\.qm,%%lang\(\1\) ,' >> %name.lang
	echo $l | sed "s,%buildroot,," >> %name.lang
done

%files
%doc gpl-3.0-exceptions.txt gpl-3.0.txt README.md LICENSE.txt
%_bindir/%name
%dir %_libdir/%name
%_libdir/lib*.so*
%_libdir/%name/*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/org.qcad.QCAD.png

%changelog
