%define qdoc_found %{expand:%%(if [ -e %_qt6_bindir/qdoc ]; then echo 1; else echo 0; fi)}
%define optflags_lto -ffat-lto-objects

%global qt_module qtmultimedia
%def_enable pulse

Name: qt6-multimedia
Version: 6.9.2
Release: alt1

Group: System/Libraries
Summary: Qt6 - Multimedia support
Url: http://qt.io/
License:  GPL-3.0-only or LGPL-3.0-only


Source: %qt_module-everywhere-src-%version.tar
Patch1: qtmultimedia-fix-build-on-x86-arch.patch

BuildRequires(pre): rpm-macros-qt6
BuildRequires(pre): qt6-tools
BuildRequires: cmake glibc-devel
BuildRequires: rpm-build-qml6
BuildRequires: qt6-base-devel qt6-declarative qt6-declarative-devel qt6-shadertools-devel qt6-svg-devel
BuildRequires: libxkbcommon-x11-devel libXrandr-devel
BuildRequires: libavformat-devel libavcodec-devel libswresample-devel libswscale-devel libavutil-devel
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(gstreamer-1.0)
BuildRequires: pkgconfig(gstreamer-app-1.0)
BuildRequires: pkgconfig(gstreamer-audio-1.0)
BuildRequires: pkgconfig(gstreamer-base-1.0)
BuildRequires: pkgconfig(gstreamer-pbutils-1.0)
BuildRequires: pkgconfig(gstreamer-plugins-bad-1.0)
BuildRequires: pkgconfig(gstreamer-video-1.0)
%if_enabled pulse
BuildRequires: pkgconfig(libpulse) pkgconfig(libpulse-mainloop-glib)
%endif
BuildRequires: pkgconfig(openal)
BuildRequires: pkgconfig(xv)

%description
The Qt Multimedia module provides a rich feature set that enables you to
easily take advantage of a platforms multimedia capabilites and hardware.
This ranges from the playback and recording of audio and video content to
the use of available devices like cameras and radios.

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: qt6-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common
Requires: qt6-base-devel
%description devel
%summary.

%package devel-static
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common
Requires: %name-devel
%description devel-static
%summary.

%package doc
Summary: Document for developing apps which will use Qt6 %qt_module
Group: Development/KDE and QT
Requires: %name-common
%description doc
This package contains documentation for Qt6 %qt_module

%package -n libqt6-multimedia
Summary: Qt6 library
Group: System/Libraries
Requires: %name-common
Requires: libqt6-core = %_qt6_version
%description -n libqt6-multimedia
%summary

%package -n libqt6-multimediaquick
Summary: Qt6 library
Group: System/Libraries
Requires: %name-common
Requires: libqt6-core = %_qt6_version
Provides: %name = %EVR
Obsoletes: %name < %EVR
Provides: qml6(QtMultimedia)
# gstreamer plugins may be required for proper audio and video playback
Requires: gst-plugins-base1.0 gst-plugins-good1.0 gst-plugins-bad1.0 gst-plugins-ugly1.0 gst-libav
#Requires: gst-plugins-good1.0-qt6
%description -n libqt6-multimediaquick
%summary

%package -n libqt6-multimediawidgets
Summary: Qt6 library
Group: System/Libraries
Requires: %name-common
Requires: libqt6-core = %_qt6_version
%description -n libqt6-multimediawidgets
%summary

%package -n libqt6-spatialaudio
Summary: Qt6 library
Group: System/Libraries
Requires: %name-common
Requires: libqt6-core = %_qt6_version
%description -n libqt6-spatialaudio
%summary


%prep
%setup -n %qt_module-everywhere-src-%version
%patch1 -p1

# disable some examples
for e in multimedia/video/qmlvideo multimedia/screencapture ; do
    exam=`basename $e`
    subdir=`dirname $e`
    sed -i "/qt_internal_add_example.*${exam}/d" examples/$subdir/CMakeLists.txt
done

%build
%ifarch %e2k
%add_optflags -mno-sse
%endif
%Q6build \
    -DQT_GENERATE_SBOM:BOOL=OFF \
    #
%if %qdoc_found
%Q6make --target docs
%endif

%install
%Q6install_qt
%if %qdoc_found
#Q6install_qt --target docs
mkdir -p %buildroot/%_docdir/qt6/
cp -ar BUILD/share/doc/qt6/* %buildroot/%_docdir/qt6/
%endif

# relax depends on plugins files
for f in %buildroot/%_libdir/cmake/Qt?*/{*,}/Qt*Targets.cmake ; do
    sed -i '/message.*FATAL_ERROR.*target.* references the file/s|FATAL_ERROR|WARNING|' $f
done

%files common
%doc LICENSES/*

%files -n libqt6-multimedia
%_qt6_libdir/libQt?Multimedia.so.*
%_qt6_plugindir/multimedia/
%files -n libqt6-multimediaquick
%_qt6_libdir/libQt?MultimediaQuick.so.*
%_qt6_archdatadir/qml/QtMultimedia/
%files -n libqt6-multimediawidgets
%_qt6_libdir/libQt?MultimediaWidgets.so.*
%files -n libqt6-spatialaudio
%_qt6_libdir/libQt?SpatialAudio.so.*

%files devel
%_qt6_headerdir/QtMultimedia*/
%_qt6_headerdir/QtSpatialAudio/
%_qt6_headerdir//Qt*MediaPlugin*/
%_qt6_libdir/lib*.so
%_qt6_libdir/lib*.a
%_qt6_libdatadir/lib*.so
%_qt6_libdatadir/lib*.a
%_qt6_libdir/lib*.prl
%_qt6_libdatadir/lib*.prl
%_qt6_libdir/cmake/Qt*/
%_qt6_archdatadir/mkspecs/modules/*.pr*
%_qt6_archdatadir/mkspecs/features/ios/*.pr*
%_qt6_archdatadir/metatypes/qt6*.json
%_qt6_archdatadir/modules/*.json
%_pkgconfigdir/Qt?*.pc

%files doc
%if %qdoc_found
%_qt6_docdir/*
%endif
%_qt6_examplesdir/*

%changelog
