%define _unpackaged_files_terminate_build 1
%define oname rabbitmq

%add_findreq_skiplist */ocf/resource.d/rabbitmq/*

Name: rabbitmq-server
Version: 3.13.7
Release: alt1

Summary: The RabbitMQ server
License: MPL-1.1
BuildArch: noarch
Group: System/Servers

Source: %name-%version.tar
Source1: rabbitmq-server.init
Source3: rabbitmq-server.logrotate
Source4: rabbitmq-env.conf
Source6: rabbitmq-server.service
Source7: rabbitmq-server.tmpfiles
Source8: rabbitmq-server-cuttlefish

Patch3: rabbitmq-server-0003-Allow-guest-login-from-non-loopback-connections.patch
Patch101: rabbitmq-common-0001-Use-proto_dist-from-command-line.patch
Patch102: rabbitmq-common-0002-force-python3.patch
Patch201: rabbitmq-script-wrapper-use-alt-specific-path.patch
Patch202: rabbitmq-server-release-0002-Revert-Use-template-in-rabbitmq-script-wrapper-for-R.patch
Patch301: rabbitmq-amqp1.0-common-0001-force-python3.patch

URL: http://www.rabbitmq.com/
VCS: https://github.com/rabbitmq/rabbitmq-server/

BuildRequires(pre): rpm-build-erlang rpm-build-python3
BuildRequires: erlang-devel
BuildRequires: erlang-otp-devel elixir
BuildRequires: python3-module-simplejson
BuildRequires: xmlto zip unzip netcat rsync

#Disable erlang autoreq to avoid unmet dependencies on rabbitmq plugins
AutoReq: noerlang
Requires: elixir
Requires: erlang >= 1:26.0
Requires: erlang-otp >= 1:26.0

%description
RabbitMQ is an implementation of AMQP, the emerging standard for high
performance enterprise messaging. The RabbitMQ server is a robust and
scalable implementation of an AMQP broker.

%prep
%setup -q

pushd deps/rabbit
%patch3 -p1
popd

pushd deps/rabbit_common
%patch101 -p1
%patch102 -p1
popd

%patch201 -p2
%patch202 -p1

pushd deps/amqp10_common
%patch301 -p1
popd

%build
export LANG=en_US.UTF-8
export VERSION=%version
#FIXME: 3.13.7: parallel build fails
%make_build -j1 V=1

%install
export LANG=en_US.UTF-8
%makeinstall_std \
        VERSION="%version" \
        PREFIX=%_prefix \
        install-bin install-man


mkdir -p %buildroot%_localstatedir/%oname/mnesia
mkdir -p %buildroot%_logdir/%oname

#Copy all necessary lib files etc.

#Sysvinit support
install -p -D -m 0755 %SOURCE1 %buildroot%_initrddir/%oname

install -p -D -m 0755 scripts/rabbitmq-script-wrapper %buildroot%_sbindir/rabbitmqctl
install -p -D -m 0755 scripts/rabbitmq-script-wrapper %buildroot%_sbindir/%{oname}-server
install -p -D -m 0755 scripts/rabbitmq-script-wrapper %buildroot%_sbindir/%{oname}-plugins

install -p -D -m 0644 %SOURCE3 %buildroot%_logrotatedir/%name
install -p -D -m 0644 %SOURCE4 %buildroot%_sysconfdir/%oname/%{oname}-env.conf
install -p -D -m 0644 deps/rabbit/docs/rabbitmq.conf.example %buildroot%_sysconfdir/%oname/rabbitmq.conf
install -p -D -m 0644 %SOURCE6 %buildroot%_unitdir/%oname.service
install -p -D -m 0644 %SOURCE7 %buildroot%_tmpfilesdir/%oname.conf
install -p -D -m 0755 %SOURCE8 %buildroot%_otplibdir/rabbitmq_server-%version/sbin/cuttlefish
install -d %buildroot%_runtimedir/%oname

# Make necessary symlinks
mkdir -p %buildroot%_libexecdir/%oname
for app in rabbitmq-defaults rabbitmq-env rabbitmq-plugins rabbitmq-server rabbitmqctl cuttlefish; do
    ln -r -s %buildroot%_erlanglibdir/rabbitmq_server-%version/sbin/${app} %buildroot%_libexecdir/%oname/${app}
done

install -p -D -m 0755 scripts/rabbitmq-server.ocf %buildroot%_libexecdir/ocf/resource.d/rabbitmq/rabbitmq-server

mkdir -p %buildroot%_sysconfdir/%oname/conf.d
rm -f %buildroot%_erlanglibdir/rabbitmq_server-%version/{LICENSE,LICENSE-*,INSTALL}

# Install completions
mkdir -p %buildroot%_datadir/bash-completion/completions
mv %buildroot/usr/lib/erlang/autocomplete/bash_autocomplete.sh %buildroot%_datadir/bash-completion/completions/%name

mkdir -p %buildroot%_datadir/zsh/site-functions
mv %buildroot/usr/lib/erlang/autocomplete/zsh_autocomplete.sh %buildroot%_datadir/zsh/site-functions/_%name
rm -rf %buildroot/usr/lib/erlang/autocomplete

%pre
%_sbindir/groupadd -r -f rabbitmq &>/dev/null
%_sbindir/useradd -r -g rabbitmq  -d %_localstatedir/rabbitmq -s /dev/null \
   -c 'RabbitMQ messaging server' -M -n rabbitmq &>/dev/null ||:

%post
%post_service %oname

%preun
%preun_service %oname

%files
%doc LICENSE LICENSE-* deps/rabbit/docs/rabbitmq.conf.example
%_sbindir/*
%_libexecdir/%oname
%dir %_erlanglibdir/rabbitmq_server-%version
%_erlanglibdir/rabbitmq_server-%version/*
%_erldir/bin/*
#%exclude %_erlanglibdir/rabbitmq_server-%version/include
%attr(0750, rabbitmq, rabbitmq) %dir %_localstatedir/%oname
%attr(0750, rabbitmq, rabbitmq) %dir %_localstatedir/%oname/mnesia
%attr(0750, rabbitmq, rabbitmq) %dir %_logdir/%oname
%attr(0750, rabbitmq, rabbitmq) %dir %_runtimedir/%oname
%dir %_sysconfdir/rabbitmq
%config(noreplace) %attr(0644, rabbitmq, rabbitmq) %_sysconfdir/rabbitmq/rabbitmq.conf
%config(noreplace) %attr(0644, rabbitmq, rabbitmq) %_sysconfdir/rabbitmq/rabbitmq-env.conf
%config(noreplace) %_logrotatedir/*
%_man5dir/*
%_man8dir/*
%_unitdir/%oname.service
%_tmpfilesdir/%oname.conf
%_initrddir/%oname
%_libexecdir/ocf/resource.d/rabbitmq
%_datadir/bash-completion/completions/%name
%_datadir/zsh/site-functions/_%name

%changelog
