%define _pseudouser_user     _radvd
%define _pseudouser_group    _radvd
%define _pseudouser_home     %_localstatedir/radvd

%define _unpackaged_files_terminate_build 1

Name: radvd
Version: 2.20
Release: alt1

Summary: A Router Advertisement daemon
# The code includes the advertising clause, so it's GPL-incompatible
License: ALT-RADVD
Group: System/Servers

Url: https://radvd.litech.org/
Vcs: https://github.com/radvd-project/radvd.git
Source0: %name-%version.tar
Source1: %name.init
Source2: %name.sysconfig
Source3: %name-tmpfs.conf
Source4: %name.conf.empty
Patch: %name-%version-%release.patch

BuildRequires: libcheck-devel
BuildRequires: flex, byacc

%description
radvd is the router advertisement daemon for IPv6.  It listens to router
solicitations and sends router advertisements as described in "Neighbor
Discovery for IP Version 6 (IPv6)" (RFC 2461).  With these advertisements
hosts can automatically configure their addresses and some other
parameters.  They also can choose a default router based on these
advertisements.

Install radvd if you are setting up IPv6 network and/or Mobile IPv6
services.

%prep
%setup
%patch -p1

%build
%autoreconf
%add_optflags -fno-strict-aliasing -fno-strict-overflow
%add_optflags -fpie
export LDFLAGS=-pie
%configure \
	--with-pidfile=/run/radvd/radvd.pid \
	--with-systemdsystemunitdir=%systemd_unitdir \
	--disable-silent-rules
%make_build

#check
#make check

%install
%makeinstall_std

mkdir -p %buildroot%_sysconfdir/sysconfig
mkdir -p %buildroot%_initdir
mkdir -p %buildroot/run/radvd

install -m 755 %SOURCE1 %buildroot%_initdir/radvd
install -m 644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/radvd
install -Dm0644 %SOURCE3 %buildroot%_tmpfilesdir/%name.conf
install -m 644 %SOURCE4 %buildroot%_sysconfdir/radvd.conf

%post
%post_service %name

%preun
%preun_service %name

%pre
/usr/sbin/groupadd -r -f %_pseudouser_group ||:
/usr/sbin/useradd -g %_pseudouser_group -N -c 'radvd user' \
        -d %_pseudouser_home -s /dev/null -r %_pseudouser_user >/dev/null 2>&1 ||:

%files
%doc COPYRIGHT README CHANGES INTRO.html TODO
%config(noreplace) %_sysconfdir/%name.conf
%config(noreplace) %_sysconfdir/sysconfig/%name
%config %_tmpfilesdir/%name.conf
%config %systemd_unitdir/%name.service
%_initdir/%name
%dir %attr(0771,root,%_pseudouser_group) /run/radvd/
%doc radvd.conf.example
%_mandir/*/*
%_sbindir/radvd
%_sbindir/radvdump

%changelog
