%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%def_without jemalloc
%def_without java
%def_with snappy
%def_with lz4
%def_with zlib
%def_with bzip2
%def_with zstd
%def_with tbb
%def_with numa
%def_without rocksdb_lite
%def_with liburing
%def_disable static

Name: rocksdb
Version: 7.9.3
Release: alt1.2
Summary: A Persistent Key-Value Store for Flash and RAM Storage
Group: Databases
# License is changed from "BSD-plus-Patents" (BSD-3-Clause) to GPL-2.0 AND Apache-2.0 in 2017.
License: GPL-2.0-only AND Apache-2.0
Url: https://rocksdb.org/
Vcs: https://github.com/facebook/rocksdb.git

Source: %name-%version.tar
Patch: %name-%version.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++
BuildRequires: libgtest-devel libgflags-devel cmake >= 3.10
%{?_with_jemalloc:BuildRequires: libjemalloc-devel}
%{?_with_java:BuildRequires: java-devel}
%{?_with_snappy:BuildRequires: libsnappy-devel}
%{?_with_lz4:BuildRequires: liblz4-devel}
%{?_with_zlib:BuildRequires: zlib-devel}
%{?_with_bzip2:BuildRequires: bzlib-devel}
%{?_with_zstd:BuildRequires: libzstd-devel}
%{?_with_tbb:BuildRequires: tbb-devel}
%{?_with_numa:BuildRequires: libnuma-devel}
%{?_with_liburing:BuildRequires: liburing-devel}

%description
Rocksdb is a library that forms the core building block for a fast key value
server, especially suited for storing data on flash drives. It has a
Log-Structured-Merge-Database (LSM) design with flexible trade offs between
Write-Amplification-Factor (WAF), Read-Amplification-Factor (RAF) and
Space-Amplification-Factor (SAF). It has multithreaded compaction, making it
specially suitable for storing multiple terabytes of data in a single database.

%package -n %name-tools
Summary: A Persistent Key-Value Store for Flash and RAM Storage (tools)
Group: System/Libraries

%description -n %name-tools
Administration and Data Access Tools

- The ldb command line tool offers multiple data access and database admin
  commands.
- sst_dump tool can be used to gain insights about a specific SST file.

%package -n lib%name
Summary: A Persistent Key-Value Store for Flash and RAM Storage
Group: System/Libraries

%description -n lib%name
Rocksdb is a library that forms the core building block for a fast key value
server, especially suited for storing data on flash drives. It has a
Log-Structured-Merge-Database (LSM) design with flexible trade offs between
Write-Amplification-Factor (WAF), Read-Amplification-Factor (RAF) and
Space-Amplification-Factor (SAF). It has multithreaded compaction, making it
specially suitable for storing multiple terabytes of data in a single database.

%package -n lib%name-devel
Summary: Development files for rocksdb
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Development files for rocksdb

%package -n lib%name-devel-static
Summary: Static library for rocksdb
Group: Development/C
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
Static library for rocksdb

%prep
%setup
%patch -p1
%ifarch %e2k
sed -i 's/#error No timer .*/return __rdtsc();/;1i #include <x86intrin.h>' \
	utilities/transactions/lock/range/range_tree/lib/portability/toku_time.h
%add_optflags -mno-sse4.2
sed -i 's/-msse4.2/-mno-sse4.2/' CMakeLists.txt
%endif
# XXX: `-mcpu=loongarch64` is NOT a valid GCC for LoongArch
sed -i '/-mcpu=loongarch64/ { d }' CMakeLists.txt

#rm -rf third-party/gtest-1.7.0
#rm java/benchmark/src/main/java/org/rocksdb/benchmark/DbBenchmark.java
rm build_tools/gnu_parallel

%build
%cmake \
    -DROCKSDB_BUILD_SHARED:BOOL=ON \
    %{?_with_jemalloc:-DWITH_JEMALLOC:BOOL=ON} \
    %{?_with_java:-DWITH_JNI:BOOL=ON} \
    %{?_with_snappy:-DWITH_SNAPPY:BOOL=ON} \
    %{?_with_zlib:-DWITH_ZLIB:BOOL=ON} \
    %{?_with_lz4:-DWITH_LZ4:BOOL=ON} \
    %{?_with_bzip2:-DWITH_BZ2:BOOL=ON} \
    %{?_with_zstd:-DWITH_ZSTD:BOOL=ON} \
    %{?_with_rocksdb_lite:-DROCKSDB_LITE:BOOL=ON} \
    %{?_without_liburing:-DWITH_LIBURING:BOOL=OFF} \
    -DWITH_CORE_TOOLS:BOOL=ON \
    -DWITH_BENCHMARK_TOOLS:BOOL=ON \
    -DWITH_TOOLS:BOOL=ON \
    -DUSE_RTTI=ON \
    -DFAIL_ON_WARNINGS=OFF \
%ifnarch %e2k
    -DPORTABLE:BOOL=ON \
%endif
    -DWITH_TESTS=ON

%cmake_build

%install
%cmake_install

%if_disabled static
rm -f %buildroot%_libdir/*.a
%endif

%files -n %name-tools
%_bindir/ldb
%_bindir/sst_dump

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_libdir/cmake/%name
%_pkgconfigdir/%name.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
