%global provider        github.com
%global project         opencontainers
%global repo            runc

%global provider_prefix %{provider}/%{project}/%{repo}
%global import_path     %{provider_prefix}

%global __find_debuginfo_files %nil
%global _unpackaged_files_terminate_build 1
%global commit      4ca628d1d4c974f92d24daccb901aa078aad748e
%global shortcommit %(c=%{commit}; echo ${c:0:7})

%set_verify_elf_method unresolved=no
%add_debuginfo_skiplist %_bindir
%brp_strip_none %_bindir/*

Name:           runc
Version:        1.3.0
Release:        alt1
Summary:        CLI for running Open Containers
Group:          Development/Other
License:        Apache-2.0
URL:            https://%provider_prefix
ExclusiveArch:  %go_arches

Source0:        %name-%version.tar

# Patches for loongarch64:
Patch1:         seccomp-upstream-support-missing-arches.patch
Patch2:         runc-alt-libcontainer-loongarch64-support.patch

BuildRequires(pre): rpm-build-golang
BuildRequires: golang go-md2man
BuildRequires: libseccomp-devel
Provides: oci-runtime
Provides: docker-runc = %version-%release
Obsoletes: docker-runc <= 1.0.0-alt2.gitb2567b3

%description
The runc command can be used to start containers which are packaged
in accordance with the Open Container Initiative's specifications,
and to manage containers running under runc.

%prep
%setup -q
%autopatch -p1
sed -i 's/ -trimpath//g' Makefile
sed -i '/\#\!\/bin\/bash/d' contrib/completions/bash/%name

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"

%golang_prepare
make COMMIT=%shortcommit BUILDTAGS="seccomp selinux" all

%install
mkdir -p -- %buildroot%_bindir
install -p -m 755 %name %buildroot%_bindir/%name

# generate man pages
man/md2man-all.sh

# install man pages
install -d -p %buildroot%_man8dir
install -p -m 0644 man/man8/*.8 %buildroot%_man8dir/
# install bash completion
install -d -p %buildroot%_datadir/bash-completion/completions
install -p -m 0644 contrib/completions/bash/%name %buildroot%_datadir/bash-completion/completions/

%files
%doc MAINTAINERS_GUIDE.md PRINCIPLES.md README.md CONTRIBUTING.md
%_bindir/*
%_man8dir/*
%_datadir/bash-completion/completions/%name

%changelog
